/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.escon.eui;

import ibm.nways.escon.model.EsconStationModel;
import ibm.nways.jdm.DestinationPropBook;
import ibm.nways.jdm.JmaColors;
import ibm.nways.jdm.NavFieldOverride;
import ibm.nways.jdm.NavInitialRow;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.RemoteModelWithStatus;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.eui.EuiGrid;
import ibm.nways.jdm.eui.EuiGridEvent;
import ibm.nways.jdm.eui.EuiGridListener;
import ibm.nways.jdm.eui.HexInput;
import ibm.nways.jdm.eui.HexInputRO;
import ibm.nways.jdm.eui.JDMInput;
import ibm.nways.jdm.eui.LongNumericInput;
import ibm.nways.jdm.eui.NumericInput;
import ibm.nways.jdm.eui.PropertySection;
import ibm.nways.jdm.eui.SingleChoiceInput;
import ibm.nways.jdm.eui.SingleChoiceInputRO;
import ibm.nways.jdm.eui.StringInput;
import ibm.nways.jdm.eui.StringInputRO;
import ibm.nways.jdm.eui.Table;
import ibm.nways.jdm.eui.TableColumn;
import ibm.nways.jdm.eui.TableColumns;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm.modelgen.TableStatus;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;

public class EsconStationPanel
extends DestinationPropBook {
    protected static ResourceBundle enumStrings = null;
    protected static ResourceBundle myResources = null;
    private static String title = "Stations";
    protected boolean containsWritableField = false;
    protected boolean containsCreatableField = false;
    protected GenModel EsconStation_model;
    protected selectionListSection selectionListPropertySection;
    protected EsconStationDetailSection EsconStationDetailPropertySection;
    protected EsconStationStatisticsSection EsconStationStatisticsPropertySection;
    protected ModelInfo EsconStationTableInfo;
    protected ModelInfo PanelInfo;
    protected ModelInfo IndexInfo;
    protected int EsconStationTableIndex;
    protected EsconStationTable EsconStationTableData;
    protected TableColumns EsconStationTableColumns;
    protected TableStatus EsconStationTableStatus;
    protected static TableColumn[] EsconStationTableCols = new TableColumn[]{new TableColumn("Index.IfIndex", "Port", 3, true), new TableColumn("Index.EsconStationHostLinkAddress", "Station Link Address", 9, true), new TableColumn("Index.EsconStationPartitionNumber", "Partition Number", 9, true), new TableColumn("Index.EsconStationDeviceAddress", "Device Address", 9, true), new TableColumn("Panel.EsconStationState", "State", 16, false)};
    protected boolean errorsFound = false;

    private static void loadStatics() {
        try {
            if (enumStrings == null) {
                enumStrings = ResourceBundle.getBundle("ibm.nways.escon.eui.EnumeratedResources");
            }
            if (myResources == null) {
                myResources = ResourceBundle.getBundle("ibm.nways.escon.eui.EsconStationPanelResources");
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Unable to access translation resources for panel EsconStation");
        }
    }

    public static String getTitle() {
        EsconStationPanel.loadStatics();
        if (myResources != null) {
            title = EsconStationPanel.getNLSString("EsconStationPanelTitle");
        }
        return title;
    }

    private static ResourceBundle getEnumStrings() {
        if (enumStrings == null) {
            EsconStationPanel.loadStatics();
        }
        return enumStrings;
    }

    public EsconStationPanel() {
        EsconStationPanel.loadStatics();
    }

    public Insets getInsets() {
        return new Insets(3, 3, 3, 3);
    }

    public String getDestinationTitle() {
        return EsconStationPanel.getTitle();
    }

    protected void getModels() {
        this.EsconStation_model = (GenModel)this.getModel();
    }

    public void addSections() {
        this.getModels();
        this.createTables();
        this.addselectionListSection();
        this.addEsconStationDetailSection();
        this.addEsconStationStatisticsSection();
        if (this.containsCreatableField) {
            this.addCreateButton();
        }
        if (this.containsWritableField) {
            this.addApplyButton();
        }
        this.addRefreshButton();
        this.addHelpButton();
        this.reset();
    }

    protected void addselectionListSection() {
        this.selectionListPropertySection = new selectionListSection();
        this.selectionListPropertySection.layoutSection();
        this.addSection(EsconStationPanel.getNLSString("selectionListSectionTitle"), this.selectionListPropertySection);
    }

    protected void addEsconStationDetailSection() {
        this.EsconStationDetailPropertySection = new EsconStationDetailSection();
        this.EsconStationDetailPropertySection.layoutSection();
        this.addSection(EsconStationPanel.getNLSString("EsconStationDetailSectionTitle"), this.EsconStationDetailPropertySection);
    }

    protected void addEsconStationStatisticsSection() {
        this.EsconStationStatisticsPropertySection = new EsconStationStatisticsSection();
        this.EsconStationStatisticsPropertySection.layoutSection();
        this.addSection(EsconStationPanel.getNLSString("EsconStationStatisticsSectionTitle"), this.EsconStationStatisticsPropertySection);
    }

    protected void panelRowChange() {
        if (this.selectionListPropertySection != null) {
            this.selectionListPropertySection.rowChange();
        }
        if (this.EsconStationDetailPropertySection != null) {
            this.EsconStationDetailPropertySection.rowChange();
        }
        if (this.EsconStationStatisticsPropertySection != null) {
            this.EsconStationStatisticsPropertySection.rowChange();
        }
    }

    public void filterPanelInfos(Vector vector) {
    }

    public int getInitialEsconStationTableRow() {
        return 0;
    }

    public ModelInfo initialEsconStationTableRow() {
        ModelInfo modelInfo = null;
        if (this.getNavContext() instanceof NavigationContext) {
            modelInfo = NavInitialRow.getInitialRow(this.getNavContext(), true);
        }
        return modelInfo;
    }

    protected void displayMsg(String string) {
        if (this.getBrowser() != null) {
            this.getBrowser().displayMsg(string);
        }
    }

    protected static String getNLSString(String string) {
        if (myResources == null) {
            return string;
        }
        try {
            return myResources.getString(string);
        }
        catch (Exception exception) {
            return string;
        }
    }

    protected String getOverride(String string, String string2) {
        String string3 = null;
        try {
            string3 = NavFieldOverride.getFieldOverride(this.getNavContext(), string);
        }
        catch (ClassCastException classCastException) {
        }
        catch (MissingResourceException missingResourceException) {
        }
        catch (NullPointerException nullPointerException) {}
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }

    public void reset() {
        this.displayMsg(EsconStationPanel.getNLSString("startResetMsg"));
        this.EsconStationTableData.invalidate();
        this.errorsFound = false;
        super.reset();
        if (!this.errorsFound) {
            this.displayMsg(EsconStationPanel.getNLSString("endResetMsg"));
            return;
        }
        this.displayMsg(String.valueOf(EsconStationPanel.getNLSString("endResetMsg")) + " " + EsconStationPanel.getNLSString("noteErrorsMsg"));
    }

    public void apply() {
        this.IndexInfo = new ModelInfo();
        this.PanelInfo = new ModelInfo();
        this.PanelInfo.add("Index.IfIndex", (Serializable)this.EsconStationTableData.getValueAt("Index.IfIndex", this.EsconStationTableIndex));
        this.PanelInfo.add("Index.EsconStationHostLinkAddress", (Serializable)this.EsconStationTableData.getValueAt("Index.EsconStationHostLinkAddress", this.EsconStationTableIndex));
        this.PanelInfo.add("Index.EsconStationPartitionNumber", (Serializable)this.EsconStationTableData.getValueAt("Index.EsconStationPartitionNumber", this.EsconStationTableIndex));
        this.PanelInfo.add("Index.EsconStationDeviceAddress", (Serializable)this.EsconStationTableData.getValueAt("Index.EsconStationDeviceAddress", this.EsconStationTableIndex));
        this.errorsFound = false;
        this.displayMsg(EsconStationPanel.getNLSString("startApplyMsg"));
        super.apply();
        if (!this.errorsFound) {
            this.EsconStationTableInfo = (ModelInfo)this.EsconStationTableData.elementAt(this.EsconStationTableIndex);
            this.EsconStationTableInfo = this.EsconStationTableData.setRow();
            this.EsconStationTableData.setElementAt(this.EsconStationTableInfo, this.EsconStationTableIndex);
            super.reset();
            if (!this.errorsFound) {
                this.displayMsg(EsconStationPanel.getNLSString("endApplyMsg"));
                return;
            }
            this.displayMsg(String.valueOf(EsconStationPanel.getNLSString("endApplyMsg")) + " " + EsconStationPanel.getNLSString("noteErrorsMsg"));
            return;
        }
        this.displayMsg(EsconStationPanel.getNLSString("abortApplyMsg"));
    }

    public void createTables() {
        this.EsconStationTableData = new EsconStationTable();
        this.EsconStationTableIndex = 0;
        this.EsconStationTableColumns = new TableColumns(EsconStationTableCols);
        if (this.EsconStation_model instanceof RemoteModelWithStatus) {
            try {
                this.EsconStationTableStatus = (TableStatus)this.EsconStation_model.getStatus();
                return;
            }
            catch (RemoteException remoteException) {
                System.out.println(remoteException);
                remoteException.printStackTrace();
                return;
            }
        }
    }

    public class selectionListSection
    extends PropertySection
    implements EuiGridListener {
        ModelInfo chunk;
        Component EsconStationTableField;
        Label EsconStationTableFieldLabel;
        boolean EsconStationTableFieldWritable = false;

        public selectionListSection() {
            EsconStationPanel.this = EsconStationPanel.this;
            this.setLayout(new GridBagLayout());
            this.setInsets(new Insets(5, 5, 5, 5));
        }

        protected Component createEsconStationTableField() {
            EuiGrid euiGrid = new EuiGrid(EsconStationPanel.this.EsconStationTableData, EsconStationPanel.this.EsconStationTableColumns, false);
            euiGrid.addRows(5);
            euiGrid.addEuiGridListener(this);
            euiGrid.setInitialRow(EsconStationPanel.this.initialEsconStationTableRow());
            this.addTable(EsconStationPanel.getNLSString("EsconStationTableLabel"), euiGrid);
            return euiGrid;
        }

        public void layoutSection() {
            this.EsconStationTableField = this.createEsconStationTableField();
        }

        public void apply() {
            if (!this.validateSection()) {
                EsconStationPanel.this.errorsFound = true;
            }
        }

        public void reset() {
            EsconStationPanel.this.displayMsg(EsconStationPanel.getNLSString("accessDataMsg"));
            EsconStationPanel.this.displayMsg(EsconStationPanel.getNLSString("startTableGetMsg"));
            ((EuiGrid)this.EsconStationTableField).refresh();
            EsconStationPanel.this.displayMsg(EsconStationPanel.getNLSString("endTableGetMsg"));
            EsconStationPanel.this.errorsFound = !this.validateSection();
            this.doLayout();
        }

        protected void rowChange() {
            this.doLayout();
        }

        public boolean validateSection() {
            return true;
        }

        public void onEuiGridEvent(EuiGridEvent euiGridEvent) {
            System.out.println("Event received in section");
            if (euiGridEvent.getType() == 2001) {
                try {
                    if (euiGridEvent.getSource() == this.EsconStationTableField) {
                        EsconStationPanel.this.EsconStationTableIndex = euiGridEvent.getRow();
                    }
                    EsconStationPanel.this.EsconStationTableIndex = euiGridEvent.getRow();
                    ((EuiGrid)this.EsconStationTableField).deselectAllRows();
                    EsconStationPanel.this.panelRowChange();
                    return;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    EuiGrid euiGrid = (EuiGrid)euiGridEvent.getSource();
                    euiGrid.deleteAllRows();
                    if (euiGridEvent.getSource() == this.EsconStationTableField) {
                        EsconStationPanel.this.EsconStationTableIndex = 0;
                    }
                    EsconStationPanel.this.selectionListPropertySection.reset();
                    EsconStationPanel.this.EsconStationDetailPropertySection.reset();
                    EsconStationPanel.this.EsconStationStatisticsPropertySection.reset();
                    return;
                }
            }
        }
    }

    public class EsconStationDetailSection
    extends PropertySection {
        ModelInfo chunk;
        Component ifIndexField;
        Component ifDescrField;
        Component esconStationHostLinkAddressField;
        Component esconStationPartitionNumberField;
        Component esconStationDeviceAddressField;
        Component esconLinkStatusField;
        Component esconStationStateField;
        Component EsconStationAttentionDelayField;
        Component esconStationMaxMsgSizeReceivedField;
        Component EsconStationMaxMsgSizeSentField;
        Label ifIndexFieldLabel;
        Label ifDescrFieldLabel;
        Label esconStationHostLinkAddressFieldLabel;
        Label esconStationPartitionNumberFieldLabel;
        Label esconStationDeviceAddressFieldLabel;
        Label esconLinkStatusFieldLabel;
        Label esconStationStateFieldLabel;
        Label EsconStationAttentionDelayFieldLabel;
        Label esconStationMaxMsgSizeReceivedFieldLabel;
        Label EsconStationMaxMsgSizeSentFieldLabel;
        boolean ifIndexFieldWritable = false;
        boolean ifDescrFieldWritable = false;
        boolean esconStationHostLinkAddressFieldWritable = false;
        boolean esconStationPartitionNumberFieldWritable = false;
        boolean esconStationDeviceAddressFieldWritable = false;
        boolean esconLinkStatusFieldWritable = false;
        boolean esconStationStateFieldWritable = false;
        boolean EsconStationAttentionDelayFieldWritable = false;
        boolean esconStationMaxMsgSizeReceivedFieldWritable = false;
        boolean EsconStationMaxMsgSizeSentFieldWritable = false;

        public EsconStationDetailSection() {
            EsconStationPanel.this = EsconStationPanel.this;
            this.setLayout(new GridBagLayout());
            this.setInsets(new Insets(5, 5, 5, 5));
        }

        protected Component createifIndexField() {
            String string = EsconStationPanel.this.getOverride("ibm.nways.escon.model.EsconStation.Index.IfIndex.access", "unknown");
            this.ifIndexFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.ifIndexFieldLabel = new Label(EsconStationPanel.getNLSString("ifIndexLabel"), 2);
            if (this.ifIndexFieldWritable) {
                NumericInput numericInput = new NumericInput();
                this.addRow(this.ifIndexFieldLabel, (Component)numericInput);
                EsconStationPanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.ifIndexFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getifIndexField() {
            JDMInput jDMInput = (JDMInput)((Object)this.ifIndexField);
            this.validateifIndexField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setifIndexField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.ifIndexField);
                jDMInput.setValue(object);
                this.validateifIndexField();
            }
        }

        protected boolean validateifIndexField() {
            JDMInput jDMInput = (JDMInput)((Object)this.ifIndexField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.ifIndexFieldLabel.setForeground(Color.yellow);
            } else {
                this.ifIndexFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createifDescrField() {
            String string = EsconStationPanel.this.getOverride("ibm.nways.escon.model.EsconStation.Panel.IfDescr.access", "read-only");
            String string2 = EsconStationPanel.this.getOverride("ibm.nways.escon.model.EsconStation.Panel.IfDescr.length", "255");
            this.ifDescrFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.ifDescrFieldLabel = new Label(EsconStationPanel.getNLSString("ifDescrLabel"), 2);
            if (this.ifDescrFieldWritable) {
                StringInput stringInput = new StringInput();
                stringInput.setMaxLength(Integer.parseInt(string2));
                this.addRow(this.ifDescrFieldLabel, (Component)stringInput);
                EsconStationPanel.this.containsWritableField = true;
                return stringInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.ifDescrFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getifDescrField() {
            JDMInput jDMInput = (JDMInput)((Object)this.ifDescrField);
            this.validateifDescrField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setifDescrField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.ifDescrField);
                jDMInput.setValue(object);
                this.validateifDescrField();
            }
        }

        protected boolean validateifDescrField() {
            JDMInput jDMInput = (JDMInput)((Object)this.ifDescrField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.ifDescrFieldLabel.setForeground(Color.yellow);
            } else {
                this.ifDescrFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createesconStationHostLinkAddressField() {
            String string = EsconStationPanel.this.getOverride("ibm.nways.escon.model.EsconStation.Index.EsconStationHostLinkAddress.access", "unknown");
            String string2 = EsconStationPanel.this.getOverride("ibm.nways.escon.model.EsconStation.Index.EsconStationHostLinkAddress.length", "1");
            this.esconStationHostLinkAddressFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.esconStationHostLinkAddressFieldLabel = new Label(EsconStationPanel.getNLSString("esconStationHostLinkAddressLabel"), 2);
            if (this.esconStationHostLinkAddressFieldWritable) {
                HexInput hexInput = new HexInput();
                hexInput.setMaxLength(Integer.parseInt(string2));
                this.addRow(this.esconStationHostLinkAddressFieldLabel, (Component)hexInput);
                EsconStationPanel.this.containsWritableField = true;
                return hexInput;
            }
            HexInputRO hexInputRO = new HexInputRO();
            this.addRow(this.esconStationHostLinkAddressFieldLabel, (Component)hexInputRO);
            return hexInputRO;
        }

        protected Serializable getesconStationHostLinkAddressField() {
            JDMInput jDMInput = (JDMInput)((Object)this.esconStationHostLinkAddressField);
            this.validateesconStationHostLinkAddressField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setesconStationHostLinkAddressField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.esconStationHostLinkAddressField);
                jDMInput.setValue(object);
                this.validateesconStationHostLinkAddressField();
            }
        }

        protected boolean validateesconStationHostLinkAddressField() {
            JDMInput jDMInput = (JDMInput)((Object)this.esconStationHostLinkAddressField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.esconStationHostLinkAddressFieldLabel.setForeground(Color.yellow);
            } else {
                this.esconStationHostLinkAddressFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createesconStationPartitionNumberField() {
            String string = EsconStationPanel.this.getOverride("ibm.nways.escon.model.EsconStation.Index.EsconStationPartitionNumber.access", "unknown");
            String string2 = EsconStationPanel.this.getOverride("ibm.nways.escon.model.EsconStation.Index.EsconStationPartitionNumber.length", "1");
            this.esconStationPartitionNumberFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.esconStationPartitionNumberFieldLabel = new Label(EsconStationPanel.getNLSString("esconStationPartitionNumberLabel"), 2);
            if (this.esconStationPartitionNumberFieldWritable) {
                HexInput hexInput = new HexInput();
                hexInput.setMaxLength(Integer.parseInt(string2));
                this.addRow(this.esconStationPartitionNumberFieldLabel, (Component)hexInput);
                EsconStationPanel.this.containsWritableField = true;
                return hexInput;
            }
            HexInputRO hexInputRO = new HexInputRO();
            this.addRow(this.esconStationPartitionNumberFieldLabel, (Component)hexInputRO);
            return hexInputRO;
        }

        protected Serializable getesconStationPartitionNumberField() {
            JDMInput jDMInput = (JDMInput)((Object)this.esconStationPartitionNumberField);
            this.validateesconStationPartitionNumberField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setesconStationPartitionNumberField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.esconStationPartitionNumberField);
                jDMInput.setValue(object);
                this.validateesconStationPartitionNumberField();
            }
        }

        protected boolean validateesconStationPartitionNumberField() {
            JDMInput jDMInput = (JDMInput)((Object)this.esconStationPartitionNumberField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.esconStationPartitionNumberFieldLabel.setForeground(Color.yellow);
            } else {
                this.esconStationPartitionNumberFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createesconStationDeviceAddressField() {
            String string = EsconStationPanel.this.getOverride("ibm.nways.escon.model.EsconStation.Index.EsconStationDeviceAddress.access", "unknown");
            String string2 = EsconStationPanel.this.getOverride("ibm.nways.escon.model.EsconStation.Index.EsconStationDeviceAddress.length", "1");
            this.esconStationDeviceAddressFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.esconStationDeviceAddressFieldLabel = new Label(EsconStationPanel.getNLSString("esconStationDeviceAddressLabel"), 2);
            if (this.esconStationDeviceAddressFieldWritable) {
                HexInput hexInput = new HexInput();
                hexInput.setMaxLength(Integer.parseInt(string2));
                this.addRow(this.esconStationDeviceAddressFieldLabel, (Component)hexInput);
                EsconStationPanel.this.containsWritableField = true;
                return hexInput;
            }
            HexInputRO hexInputRO = new HexInputRO();
            this.addRow(this.esconStationDeviceAddressFieldLabel, (Component)hexInputRO);
            return hexInputRO;
        }

        protected Serializable getesconStationDeviceAddressField() {
            JDMInput jDMInput = (JDMInput)((Object)this.esconStationDeviceAddressField);
            this.validateesconStationDeviceAddressField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setesconStationDeviceAddressField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.esconStationDeviceAddressField);
                jDMInput.setValue(object);
                this.validateesconStationDeviceAddressField();
            }
        }

        protected boolean validateesconStationDeviceAddressField() {
            JDMInput jDMInput = (JDMInput)((Object)this.esconStationDeviceAddressField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.esconStationDeviceAddressFieldLabel.setForeground(Color.yellow);
            } else {
                this.esconStationDeviceAddressFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createesconLinkStatusField() {
            String string = EsconStationPanel.this.getOverride("ibm.nways.escon.model.EsconStation.Panel.EsconLinkStatus.access", "read-only");
            this.esconLinkStatusFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.esconLinkStatusFieldLabel = new Label(EsconStationPanel.getNLSString("esconLinkStatusLabel"), 2);
            if (this.esconLinkStatusFieldWritable) {
                SingleChoiceInput singleChoiceInput = new SingleChoiceInput(EsconStationModel.Panel.EsconLinkStatusEnum.symbolicValues, EsconStationModel.Panel.EsconLinkStatusEnum.numericValues, EsconStationPanel.getEnumStrings());
                this.addRow(this.esconLinkStatusFieldLabel, (Component)singleChoiceInput);
                EsconStationPanel.this.containsWritableField = true;
                return singleChoiceInput;
            }
            SingleChoiceInputRO singleChoiceInputRO = new SingleChoiceInputRO(EsconStationModel.Panel.EsconLinkStatusEnum.symbolicValues, EsconStationModel.Panel.EsconLinkStatusEnum.numericValues, EsconStationPanel.getEnumStrings());
            this.addRow(this.esconLinkStatusFieldLabel, (Component)singleChoiceInputRO);
            return singleChoiceInputRO;
        }

        protected Serializable getesconLinkStatusField() {
            JDMInput jDMInput = (JDMInput)((Object)this.esconLinkStatusField);
            this.validateesconLinkStatusField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setesconLinkStatusField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.esconLinkStatusField);
                jDMInput.setValue(object);
                this.validateesconLinkStatusField();
            }
        }

        protected boolean validateesconLinkStatusField() {
            JDMInput jDMInput = (JDMInput)((Object)this.esconLinkStatusField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.esconLinkStatusFieldLabel.setForeground(Color.yellow);
            } else {
                this.esconLinkStatusFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createesconStationStateField() {
            String string = EsconStationPanel.this.getOverride("ibm.nways.escon.model.EsconStation.Panel.EsconStationState.access", "read-only");
            this.esconStationStateFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.esconStationStateFieldLabel = new Label(EsconStationPanel.getNLSString("esconStationStateLabel"), 2);
            if (this.esconStationStateFieldWritable) {
                SingleChoiceInput singleChoiceInput = new SingleChoiceInput(EsconStationModel.Panel.EsconStationStateEnum.symbolicValues, EsconStationModel.Panel.EsconStationStateEnum.numericValues, EsconStationPanel.getEnumStrings());
                this.addRow(this.esconStationStateFieldLabel, (Component)singleChoiceInput);
                EsconStationPanel.this.containsWritableField = true;
                return singleChoiceInput;
            }
            SingleChoiceInputRO singleChoiceInputRO = new SingleChoiceInputRO(EsconStationModel.Panel.EsconStationStateEnum.symbolicValues, EsconStationModel.Panel.EsconStationStateEnum.numericValues, EsconStationPanel.getEnumStrings());
            this.addRow(this.esconStationStateFieldLabel, (Component)singleChoiceInputRO);
            return singleChoiceInputRO;
        }

        protected Serializable getesconStationStateField() {
            JDMInput jDMInput = (JDMInput)((Object)this.esconStationStateField);
            this.validateesconStationStateField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setesconStationStateField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.esconStationStateField);
                jDMInput.setValue(object);
                this.validateesconStationStateField();
            }
        }

        protected boolean validateesconStationStateField() {
            JDMInput jDMInput = (JDMInput)((Object)this.esconStationStateField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.esconStationStateFieldLabel.setForeground(Color.yellow);
            } else {
                this.esconStationStateFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createEsconStationAttentionDelayField() {
            String string = EsconStationPanel.this.getOverride("ibm.nways.escon.model.EsconStation.Panel.EsconStationAttentionDelay.access", "read-write");
            this.EsconStationAttentionDelayFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.EsconStationAttentionDelayFieldLabel = new Label(EsconStationPanel.getNLSString("EsconStationAttentionDelayLabel"), 2);
            if (this.EsconStationAttentionDelayFieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(0, 420);
                this.addRow(this.EsconStationAttentionDelayFieldLabel, (Component)numericInput);
                EsconStationPanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.EsconStationAttentionDelayFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getEsconStationAttentionDelayField() {
            JDMInput jDMInput = (JDMInput)((Object)this.EsconStationAttentionDelayField);
            this.validateEsconStationAttentionDelayField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setEsconStationAttentionDelayField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.EsconStationAttentionDelayField);
                jDMInput.setValue(object);
                this.validateEsconStationAttentionDelayField();
            }
        }

        protected boolean validateEsconStationAttentionDelayField() {
            JDMInput jDMInput = (JDMInput)((Object)this.EsconStationAttentionDelayField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.EsconStationAttentionDelayFieldLabel.setForeground(Color.yellow);
            } else {
                this.EsconStationAttentionDelayFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createesconStationMaxMsgSizeReceivedField() {
            String string = EsconStationPanel.this.getOverride("ibm.nways.escon.model.EsconStation.Panel.EsconStationMaxMsgSizeReceived.access", "read-write");
            this.esconStationMaxMsgSizeReceivedFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.esconStationMaxMsgSizeReceivedFieldLabel = new Label(EsconStationPanel.getNLSString("esconStationMaxMsgSizeReceivedLabel"), 2);
            if (this.esconStationMaxMsgSizeReceivedFieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(0, 65535);
                this.addRow(this.esconStationMaxMsgSizeReceivedFieldLabel, (Component)numericInput);
                EsconStationPanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.esconStationMaxMsgSizeReceivedFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getesconStationMaxMsgSizeReceivedField() {
            JDMInput jDMInput = (JDMInput)((Object)this.esconStationMaxMsgSizeReceivedField);
            this.validateesconStationMaxMsgSizeReceivedField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setesconStationMaxMsgSizeReceivedField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.esconStationMaxMsgSizeReceivedField);
                jDMInput.setValue(object);
                this.validateesconStationMaxMsgSizeReceivedField();
            }
        }

        protected boolean validateesconStationMaxMsgSizeReceivedField() {
            JDMInput jDMInput = (JDMInput)((Object)this.esconStationMaxMsgSizeReceivedField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.esconStationMaxMsgSizeReceivedFieldLabel.setForeground(Color.yellow);
            } else {
                this.esconStationMaxMsgSizeReceivedFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createEsconStationMaxMsgSizeSentField() {
            String string = EsconStationPanel.this.getOverride("ibm.nways.escon.model.EsconStation.Panel.EsconStationMaxMsgSizeSent.access", "read-write");
            this.EsconStationMaxMsgSizeSentFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.EsconStationMaxMsgSizeSentFieldLabel = new Label(EsconStationPanel.getNLSString("EsconStationMaxMsgSizeSentLabel"), 2);
            if (this.EsconStationMaxMsgSizeSentFieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(0, 65535);
                this.addRow(this.EsconStationMaxMsgSizeSentFieldLabel, (Component)numericInput);
                EsconStationPanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.EsconStationMaxMsgSizeSentFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getEsconStationMaxMsgSizeSentField() {
            JDMInput jDMInput = (JDMInput)((Object)this.EsconStationMaxMsgSizeSentField);
            this.validateEsconStationMaxMsgSizeSentField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setEsconStationMaxMsgSizeSentField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.EsconStationMaxMsgSizeSentField);
                jDMInput.setValue(object);
                this.validateEsconStationMaxMsgSizeSentField();
            }
        }

        protected boolean validateEsconStationMaxMsgSizeSentField() {
            JDMInput jDMInput = (JDMInput)((Object)this.EsconStationMaxMsgSizeSentField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.EsconStationMaxMsgSizeSentFieldLabel.setForeground(Color.yellow);
            } else {
                this.EsconStationMaxMsgSizeSentFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        public void layoutSection() {
            this.ifIndexField = this.createifIndexField();
            this.ifDescrField = this.createifDescrField();
            this.esconStationHostLinkAddressField = this.createesconStationHostLinkAddressField();
            this.esconStationPartitionNumberField = this.createesconStationPartitionNumberField();
            this.esconStationDeviceAddressField = this.createesconStationDeviceAddressField();
            this.esconLinkStatusField = this.createesconLinkStatusField();
            this.esconStationStateField = this.createesconStationStateField();
            this.EsconStationAttentionDelayField = this.createEsconStationAttentionDelayField();
            this.esconStationMaxMsgSizeReceivedField = this.createesconStationMaxMsgSizeReceivedField();
            this.EsconStationMaxMsgSizeSentField = this.createEsconStationMaxMsgSizeSentField();
        }

        public void apply() {
            if (this.validateSection()) {
                if (!((JDMInput)((Object)this.ifIndexField)).ignoreValue() && this.ifIndexFieldWritable) {
                    EsconStationPanel.this.IndexInfo.add("Index.IfIndex", this.getifIndexField());
                }
                if (!((JDMInput)((Object)this.ifDescrField)).ignoreValue() && this.ifDescrFieldWritable) {
                    EsconStationPanel.this.PanelInfo.add("Panel.IfDescr", this.getifDescrField());
                }
                if (!((JDMInput)((Object)this.esconStationHostLinkAddressField)).ignoreValue() && this.esconStationHostLinkAddressFieldWritable) {
                    EsconStationPanel.this.IndexInfo.add("Index.EsconStationHostLinkAddress", this.getesconStationHostLinkAddressField());
                }
                if (!((JDMInput)((Object)this.esconStationPartitionNumberField)).ignoreValue() && this.esconStationPartitionNumberFieldWritable) {
                    EsconStationPanel.this.IndexInfo.add("Index.EsconStationPartitionNumber", this.getesconStationPartitionNumberField());
                }
                if (!((JDMInput)((Object)this.esconStationDeviceAddressField)).ignoreValue() && this.esconStationDeviceAddressFieldWritable) {
                    EsconStationPanel.this.IndexInfo.add("Index.EsconStationDeviceAddress", this.getesconStationDeviceAddressField());
                }
                if (!((JDMInput)((Object)this.esconLinkStatusField)).ignoreValue() && this.esconLinkStatusFieldWritable) {
                    EsconStationPanel.this.PanelInfo.add("Panel.EsconLinkStatus", this.getesconLinkStatusField());
                }
                if (!((JDMInput)((Object)this.esconStationStateField)).ignoreValue() && this.esconStationStateFieldWritable) {
                    EsconStationPanel.this.PanelInfo.add("Panel.EsconStationState", this.getesconStationStateField());
                }
                if (!((JDMInput)((Object)this.EsconStationAttentionDelayField)).ignoreValue() && this.EsconStationAttentionDelayFieldWritable) {
                    EsconStationPanel.this.PanelInfo.add("Panel.EsconStationAttentionDelay", this.getEsconStationAttentionDelayField());
                }
                if (!((JDMInput)((Object)this.esconStationMaxMsgSizeReceivedField)).ignoreValue() && this.esconStationMaxMsgSizeReceivedFieldWritable) {
                    EsconStationPanel.this.PanelInfo.add("Panel.EsconStationMaxMsgSizeReceived", this.getesconStationMaxMsgSizeReceivedField());
                }
                if (!((JDMInput)((Object)this.EsconStationMaxMsgSizeSentField)).ignoreValue() && this.EsconStationMaxMsgSizeSentFieldWritable) {
                    EsconStationPanel.this.PanelInfo.add("Panel.EsconStationMaxMsgSizeSent", this.getEsconStationMaxMsgSizeSentField());
                    return;
                }
            } else {
                EsconStationPanel.this.errorsFound = true;
            }
        }

        public void reset() {
            EsconStationPanel.this.displayMsg(EsconStationPanel.getNLSString("accessDataMsg"));
            try {
                this.setifIndexField(EsconStationPanel.this.EsconStationTableData.getValueAt("Index.IfIndex", EsconStationPanel.this.EsconStationTableIndex));
                this.setifDescrField(EsconStationPanel.this.EsconStationTableData.getValueAt("Panel.IfDescr", EsconStationPanel.this.EsconStationTableIndex));
                this.setesconStationHostLinkAddressField(EsconStationPanel.this.EsconStationTableData.getValueAt("Index.EsconStationHostLinkAddress", EsconStationPanel.this.EsconStationTableIndex));
                this.setesconStationPartitionNumberField(EsconStationPanel.this.EsconStationTableData.getValueAt("Index.EsconStationPartitionNumber", EsconStationPanel.this.EsconStationTableIndex));
                this.setesconStationDeviceAddressField(EsconStationPanel.this.EsconStationTableData.getValueAt("Index.EsconStationDeviceAddress", EsconStationPanel.this.EsconStationTableIndex));
                this.setesconLinkStatusField(EsconStationPanel.this.EsconStationTableData.getValueAt("Panel.EsconLinkStatus", EsconStationPanel.this.EsconStationTableIndex));
                this.setesconStationStateField(EsconStationPanel.this.EsconStationTableData.getValueAt("Panel.EsconStationState", EsconStationPanel.this.EsconStationTableIndex));
                this.setEsconStationAttentionDelayField(EsconStationPanel.this.EsconStationTableData.getValueAt("Panel.EsconStationAttentionDelay", EsconStationPanel.this.EsconStationTableIndex));
                this.setesconStationMaxMsgSizeReceivedField(EsconStationPanel.this.EsconStationTableData.getValueAt("Panel.EsconStationMaxMsgSizeReceived", EsconStationPanel.this.EsconStationTableIndex));
                this.setEsconStationMaxMsgSizeSentField(EsconStationPanel.this.EsconStationTableData.getValueAt("Panel.EsconStationMaxMsgSizeSent", EsconStationPanel.this.EsconStationTableIndex));
            }
            catch (NullPointerException nullPointerException) {}
            EsconStationPanel.this.errorsFound = !this.validateSection();
            this.doLayout();
        }

        protected void rowChange() {
            this.setifIndexField(EsconStationPanel.this.EsconStationTableData.getValueAt("Index.IfIndex", EsconStationPanel.this.EsconStationTableIndex));
            this.setifDescrField(EsconStationPanel.this.EsconStationTableData.getValueAt("Panel.IfDescr", EsconStationPanel.this.EsconStationTableIndex));
            this.setesconStationHostLinkAddressField(EsconStationPanel.this.EsconStationTableData.getValueAt("Index.EsconStationHostLinkAddress", EsconStationPanel.this.EsconStationTableIndex));
            this.setesconStationPartitionNumberField(EsconStationPanel.this.EsconStationTableData.getValueAt("Index.EsconStationPartitionNumber", EsconStationPanel.this.EsconStationTableIndex));
            this.setesconStationDeviceAddressField(EsconStationPanel.this.EsconStationTableData.getValueAt("Index.EsconStationDeviceAddress", EsconStationPanel.this.EsconStationTableIndex));
            this.setesconLinkStatusField(EsconStationPanel.this.EsconStationTableData.getValueAt("Panel.EsconLinkStatus", EsconStationPanel.this.EsconStationTableIndex));
            this.setesconStationStateField(EsconStationPanel.this.EsconStationTableData.getValueAt("Panel.EsconStationState", EsconStationPanel.this.EsconStationTableIndex));
            this.setEsconStationAttentionDelayField(EsconStationPanel.this.EsconStationTableData.getValueAt("Panel.EsconStationAttentionDelay", EsconStationPanel.this.EsconStationTableIndex));
            this.setesconStationMaxMsgSizeReceivedField(EsconStationPanel.this.EsconStationTableData.getValueAt("Panel.EsconStationMaxMsgSizeReceived", EsconStationPanel.this.EsconStationTableIndex));
            this.setEsconStationMaxMsgSizeSentField(EsconStationPanel.this.EsconStationTableData.getValueAt("Panel.EsconStationMaxMsgSizeSent", EsconStationPanel.this.EsconStationTableIndex));
            this.doLayout();
        }

        public boolean validateSection() {
            if (!((JDMInput)((Object)this.EsconStationAttentionDelayField)).ignoreValue() && !this.validateEsconStationAttentionDelayField()) {
                return false;
            }
            if (!((JDMInput)((Object)this.esconStationMaxMsgSizeReceivedField)).ignoreValue() && !this.validateesconStationMaxMsgSizeReceivedField()) {
                return false;
            }
            return ((JDMInput)((Object)this.EsconStationMaxMsgSizeSentField)).ignoreValue() || this.validateEsconStationMaxMsgSizeSentField();
        }
    }

    public class EsconStationStatisticsSection
    extends PropertySection {
        ModelInfo chunk;
        Component esconStationDataPacketsOkReceivedField;
        Component esconStationDataPacketsSentField;
        Component esconStationTotalFramesSentField;
        Label esconStationDataPacketsOkReceivedFieldLabel;
        Label esconStationDataPacketsSentFieldLabel;
        Label esconStationTotalFramesSentFieldLabel;
        boolean esconStationDataPacketsOkReceivedFieldWritable = false;
        boolean esconStationDataPacketsSentFieldWritable = false;
        boolean esconStationTotalFramesSentFieldWritable = false;

        public EsconStationStatisticsSection() {
            EsconStationPanel.this = EsconStationPanel.this;
            this.setLayout(new GridBagLayout());
            this.setInsets(new Insets(5, 5, 5, 5));
        }

        protected Component createesconStationDataPacketsOkReceivedField() {
            String string = EsconStationPanel.this.getOverride("ibm.nways.escon.model.EsconStation.Panel.EsconStationDataPacketsOkReceived.access", "read-only");
            this.esconStationDataPacketsOkReceivedFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.esconStationDataPacketsOkReceivedFieldLabel = new Label(EsconStationPanel.getNLSString("esconStationDataPacketsOkReceivedLabel"), 2);
            if (this.esconStationDataPacketsOkReceivedFieldWritable) {
                LongNumericInput longNumericInput = new LongNumericInput();
                this.addRow(this.esconStationDataPacketsOkReceivedFieldLabel, (Component)longNumericInput);
                EsconStationPanel.this.containsWritableField = true;
                return longNumericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.esconStationDataPacketsOkReceivedFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getesconStationDataPacketsOkReceivedField() {
            JDMInput jDMInput = (JDMInput)((Object)this.esconStationDataPacketsOkReceivedField);
            this.validateesconStationDataPacketsOkReceivedField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setesconStationDataPacketsOkReceivedField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.esconStationDataPacketsOkReceivedField);
                jDMInput.setValue(object);
                this.validateesconStationDataPacketsOkReceivedField();
            }
        }

        protected boolean validateesconStationDataPacketsOkReceivedField() {
            JDMInput jDMInput = (JDMInput)((Object)this.esconStationDataPacketsOkReceivedField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.esconStationDataPacketsOkReceivedFieldLabel.setForeground(Color.yellow);
            } else {
                this.esconStationDataPacketsOkReceivedFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createesconStationDataPacketsSentField() {
            String string = EsconStationPanel.this.getOverride("ibm.nways.escon.model.EsconStation.Panel.EsconStationDataPacketsSent.access", "read-only");
            this.esconStationDataPacketsSentFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.esconStationDataPacketsSentFieldLabel = new Label(EsconStationPanel.getNLSString("esconStationDataPacketsSentLabel"), 2);
            if (this.esconStationDataPacketsSentFieldWritable) {
                LongNumericInput longNumericInput = new LongNumericInput();
                this.addRow(this.esconStationDataPacketsSentFieldLabel, (Component)longNumericInput);
                EsconStationPanel.this.containsWritableField = true;
                return longNumericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.esconStationDataPacketsSentFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getesconStationDataPacketsSentField() {
            JDMInput jDMInput = (JDMInput)((Object)this.esconStationDataPacketsSentField);
            this.validateesconStationDataPacketsSentField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setesconStationDataPacketsSentField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.esconStationDataPacketsSentField);
                jDMInput.setValue(object);
                this.validateesconStationDataPacketsSentField();
            }
        }

        protected boolean validateesconStationDataPacketsSentField() {
            JDMInput jDMInput = (JDMInput)((Object)this.esconStationDataPacketsSentField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.esconStationDataPacketsSentFieldLabel.setForeground(Color.yellow);
            } else {
                this.esconStationDataPacketsSentFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createesconStationTotalFramesSentField() {
            String string = EsconStationPanel.this.getOverride("ibm.nways.escon.model.EsconStation.Panel.EsconStationTotalFramesSent.access", "read-only");
            this.esconStationTotalFramesSentFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.esconStationTotalFramesSentFieldLabel = new Label(EsconStationPanel.getNLSString("esconStationTotalFramesSentLabel"), 2);
            if (this.esconStationTotalFramesSentFieldWritable) {
                LongNumericInput longNumericInput = new LongNumericInput();
                this.addRow(this.esconStationTotalFramesSentFieldLabel, (Component)longNumericInput);
                EsconStationPanel.this.containsWritableField = true;
                return longNumericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.esconStationTotalFramesSentFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getesconStationTotalFramesSentField() {
            JDMInput jDMInput = (JDMInput)((Object)this.esconStationTotalFramesSentField);
            this.validateesconStationTotalFramesSentField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setesconStationTotalFramesSentField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.esconStationTotalFramesSentField);
                jDMInput.setValue(object);
                this.validateesconStationTotalFramesSentField();
            }
        }

        protected boolean validateesconStationTotalFramesSentField() {
            JDMInput jDMInput = (JDMInput)((Object)this.esconStationTotalFramesSentField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.esconStationTotalFramesSentFieldLabel.setForeground(Color.yellow);
            } else {
                this.esconStationTotalFramesSentFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        public void layoutSection() {
            this.esconStationDataPacketsOkReceivedField = this.createesconStationDataPacketsOkReceivedField();
            this.esconStationDataPacketsSentField = this.createesconStationDataPacketsSentField();
            this.esconStationTotalFramesSentField = this.createesconStationTotalFramesSentField();
        }

        public void apply() {
            if (this.validateSection()) {
                if (!((JDMInput)((Object)this.esconStationDataPacketsOkReceivedField)).ignoreValue() && this.esconStationDataPacketsOkReceivedFieldWritable) {
                    EsconStationPanel.this.PanelInfo.add("Panel.EsconStationDataPacketsOkReceived", this.getesconStationDataPacketsOkReceivedField());
                }
                if (!((JDMInput)((Object)this.esconStationDataPacketsSentField)).ignoreValue() && this.esconStationDataPacketsSentFieldWritable) {
                    EsconStationPanel.this.PanelInfo.add("Panel.EsconStationDataPacketsSent", this.getesconStationDataPacketsSentField());
                }
                if (!((JDMInput)((Object)this.esconStationTotalFramesSentField)).ignoreValue() && this.esconStationTotalFramesSentFieldWritable) {
                    EsconStationPanel.this.PanelInfo.add("Panel.EsconStationTotalFramesSent", this.getesconStationTotalFramesSentField());
                    return;
                }
            } else {
                EsconStationPanel.this.errorsFound = true;
            }
        }

        public void reset() {
            EsconStationPanel.this.displayMsg(EsconStationPanel.getNLSString("accessDataMsg"));
            try {
                this.setesconStationDataPacketsOkReceivedField(EsconStationPanel.this.EsconStationTableData.getValueAt("Panel.EsconStationDataPacketsOkReceived", EsconStationPanel.this.EsconStationTableIndex));
                this.setesconStationDataPacketsSentField(EsconStationPanel.this.EsconStationTableData.getValueAt("Panel.EsconStationDataPacketsSent", EsconStationPanel.this.EsconStationTableIndex));
                this.setesconStationTotalFramesSentField(EsconStationPanel.this.EsconStationTableData.getValueAt("Panel.EsconStationTotalFramesSent", EsconStationPanel.this.EsconStationTableIndex));
            }
            catch (NullPointerException nullPointerException) {}
            EsconStationPanel.this.errorsFound = !this.validateSection();
            this.doLayout();
        }

        protected void rowChange() {
            this.setesconStationDataPacketsOkReceivedField(EsconStationPanel.this.EsconStationTableData.getValueAt("Panel.EsconStationDataPacketsOkReceived", EsconStationPanel.this.EsconStationTableIndex));
            this.setesconStationDataPacketsSentField(EsconStationPanel.this.EsconStationTableData.getValueAt("Panel.EsconStationDataPacketsSent", EsconStationPanel.this.EsconStationTableIndex));
            this.setesconStationTotalFramesSentField(EsconStationPanel.this.EsconStationTableData.getValueAt("Panel.EsconStationTotalFramesSent", EsconStationPanel.this.EsconStationTableIndex));
            this.doLayout();
        }

        public boolean validateSection() {
            return true;
        }
    }

    public class EsconStationTable
    extends Table {
        public ModelInfo setRow() {
            try {
                EsconStationPanel.this.displayMsg(EsconStationPanel.getNLSString("startSendMsg"));
                EsconStationPanel.this.PanelInfo = EsconStationPanel.this.EsconStation_model.setInfo("Panel", EsconStationPanel.this.PanelInfo);
                EsconStationPanel.this.displayMsg(EsconStationPanel.getNLSString("endSendMsg"));
                if (EsconStationPanel.this.PanelInfo != null) {
                    Enumeration enumeration = EsconStationPanel.this.PanelInfo.getItemIds();
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        Serializable serializable = EsconStationPanel.this.PanelInfo.get(string);
                        EsconStationPanel.this.EsconStationTableInfo.add(string, serializable);
                    }
                }
            }
            catch (RemoteException remoteException) {
                System.out.println(remoteException);
                remoteException.printStackTrace();
            }
            return EsconStationPanel.this.EsconStationTableInfo;
        }

        public ModelInfo getRow(ModelInfo modelInfo) {
            try {
                while (true) {
                    EsconStationPanel.this.EsconStationTableInfo = null;
                    EsconStationPanel.this.displayMsg(EsconStationPanel.getNLSString("startRow"));
                    EsconStationPanel.this.PanelInfo = EsconStationPanel.this.EsconStation_model.getNextInfo("Panel", "default", modelInfo);
                    EsconStationPanel.this.displayMsg(EsconStationPanel.getNLSString("endRow"));
                    if (EsconStationPanel.this.PanelInfo != null) {
                        EsconStationPanel.this.EsconStationTableInfo = new ModelInfo();
                        if (EsconStationPanel.this.PanelInfo.isBeingMonitored()) {
                            EsconStationPanel.this.EsconStationTableInfo.flagAsMonitored();
                        }
                        Enumeration enumeration = EsconStationPanel.this.PanelInfo.getItemIds();
                        while (enumeration.hasMoreElements()) {
                            String string = (String)enumeration.nextElement();
                            Serializable serializable = EsconStationPanel.this.PanelInfo.get(string);
                            EsconStationPanel.this.EsconStationTableInfo.add(string, serializable);
                        }
                    }
                    if (EsconStationPanel.this.EsconStationTableInfo != null && !this.validRow(EsconStationPanel.this.EsconStationTableInfo)) {
                        modelInfo = EsconStationPanel.this.EsconStationTableInfo;
                        continue;
                    }
                    break;
                }
            }
            catch (RemoteException remoteException) {
                System.out.println(remoteException);
                remoteException.printStackTrace();
            }
            return EsconStationPanel.this.EsconStationTableInfo;
        }

        public ModelInfo getSpecificRow(ModelInfo modelInfo) {
            EsconStationPanel.this.EsconStationTableInfo = null;
            try {
                EsconStationPanel.this.displayMsg(EsconStationPanel.getNLSString("startRow"));
                EsconStationPanel.this.PanelInfo = EsconStationPanel.this.EsconStation_model.getInfo("Panel", "default", modelInfo);
                EsconStationPanel.this.displayMsg(EsconStationPanel.getNLSString("endRow"));
                if (EsconStationPanel.this.PanelInfo != null) {
                    EsconStationPanel.this.EsconStationTableInfo = new ModelInfo();
                    if (EsconStationPanel.this.PanelInfo.isBeingMonitored()) {
                        EsconStationPanel.this.EsconStationTableInfo.flagAsMonitored();
                    }
                    Enumeration enumeration = EsconStationPanel.this.PanelInfo.getItemIds();
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        Serializable serializable = EsconStationPanel.this.PanelInfo.get(string);
                        EsconStationPanel.this.EsconStationTableInfo.add(string, serializable);
                    }
                }
                if (EsconStationPanel.this.EsconStationTableInfo != null && !this.validRow(EsconStationPanel.this.EsconStationTableInfo)) {
                    EsconStationPanel.this.EsconStationTableInfo = this.getRow(EsconStationPanel.this.EsconStationTableInfo);
                }
            }
            catch (RemoteException remoteException) {
                System.out.println(remoteException);
                remoteException.printStackTrace();
            }
            return EsconStationPanel.this.EsconStationTableInfo;
        }

        public boolean validRow(ModelInfo modelInfo) {
            return true;
        }

        public void setMonitoring(ModelInfo[] modelInfoArray, boolean bl) {
            try {
                if (EsconStationPanel.this.EsconStationTableStatus != null) {
                    if (modelInfoArray != null) {
                        if (bl) {
                            EsconStationPanel.this.EsconStationTableStatus.monitor(modelInfoArray);
                            return;
                        }
                        EsconStationPanel.this.EsconStationTableStatus.doNotMonitor(modelInfoArray);
                        return;
                    }
                    if (bl) {
                        EsconStationPanel.this.EsconStationTableStatus.setMaxRows(Integer.MAX_VALUE);
                        return;
                    }
                    EsconStationPanel.this.EsconStationTableStatus.setMaxRows(0);
                    return;
                }
            }
            catch (RemoteException remoteException) {
                System.out.println(remoteException);
                remoteException.printStackTrace();
            }
        }

        public String translateEnum(String string, int n) {
            String string2 = String.valueOf(n);
            try {
                if (string.equals("Panel.EsconStationState")) {
                    string2 = enumStrings.getString(EsconStationModel.Panel.EsconStationStateEnum.numericToSymbolic(n));
                }
            }
            catch (MissingResourceException missingResourceException) {}
            return string2;
        }

        public EsconStationTable() {
            EsconStationPanel.this = EsconStationPanel.this;
        }
    }
}

